<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

interface InterfaceUserGetter
{
    public function getId(): string;

    public function getEmail(): string;

    public function getUsername(): string;

    public function getPassword(): string;

    public function getDisplayName(): string;

    public function getDisplayBio(): string;

    public function getDisplayImage(): UserDisplayImageDTO;

    public function getDisplayWeb(): string;

    public function getMetaAccess(): string;

    public function getMetaIsPrivate(): string;

    public function getMetaIsEmailVerified(): string;

    public function getMetaLastActive(): string;

    public function getMetaPushSettings(): UserMetaPushSettingsDTO;

    public function getCachePostsCount(): string;

    public function getCacheFollowersCount(): string;

    public function getCacheFollowingsCount(): string;

    public function getCacheBlockedUserIds(): UserIdsDTO;

    public function getStampRegistration(): string;

    public function getStampLastUpdate(): string;
}
